unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMObj, MMDSPObj, MMWavIn, MMSystem, MMRegs, StdCtrls, MMWRec, MMHook,
  MMDesign, MMWave;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    WaveIn: TMMWaveIn;
    WaveFile: TMMWaveFile;
    MMDesigner1: TMMDesigner;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
function CreateMP2Format: TMPEG1WaveFormat;
var
   wSamplesPerBlock: Integer;
   glBitRate: LongInt;
   glChannels: Integer;
   glSampleRate: Integer;
begin
   glBitRate := 128000;
   glChannels := 2;
   glSampleRate := 44100;

   with Result do
   begin
      wfx.wFormatTag     := WAVE_FORMAT_MPEG;
      wfx.nChannels      := glChannels;
      wfx.nSamplesPerSec := glSampleRate;
      wfx.wBitsPerSample := 16;
      wfx.nAvgBytesPerSec:= 0;
      wfx.nBlockAlign    := 144 * (glBitRate * wfx.nChannels) div glSampleRate;
      wfx.cbSize         := 22;
      wSamplesPerBlock   := 1120;
      fwHeadLayer        := ACM_MPEG_LAYER2;
      fwHeadModeExt      := $0F;
      wHeadEmphasis      := 1;   // no emphasis
      fwHeadFlags        := ACM_MPEG_ID_MPEG1; //ACM_MPEG_PROTECTIONBIT or ACM_MPEG_COPYRIGHT or ACM_MPEG_ORIGINALHOME
      dwPTSLow           := 0;
      dwPTSHigh          := 0;
      if (wfx.nChannels = 1) then
          fwHeadMode     := ACM_MPEG_SINGLECHANNEL
      else
          fwHeadMode     := ACM_MPEG_JOINTSTEREO;

      dwHeadBitrate      := glBitRate * wfx.nChannels;

      wfx.nAvgBytesPerSec:= (((wfx.nSamplesPerSec * 100) div wSamplesPerBlock)*wfx.nBlockAlign) div 100;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.Button1Click(Sender: TObject);
var
   mpwfx : TMpeg1WaveFormat;
begin
   WaveFile.Wave.FileName := 'C:\TEST.WAV';
   
   mpwfx := CreateMP2Format;
   WaveIn.PWaveFormat := @mpwfx;

   WaveIn.Start;
end;

{------------------------------------------------------------------------------}
procedure TForm1.Button2Click(Sender: TObject);
begin
   WaveIn.Close;
end;

end.
